Stick = class()

function Stick:init()
    self.direction = 0
    self.dist = 0

    self.active = false
    self.origin = vec2(150, 150)
    self.center = self.origin
    self.pos = self.origin

    self.stick_bg = readImage("Space Art:Eclipse")
    self.stick = readImage(asset.builtin.UI.Blue_Box_Tick)

end

function Stick:draw()
    scaler = .9
    sprite(self.stick_bg, self.center.x, self.center.y)
    sprite(self.stick, self.pos.x, self.pos.y, self.stick.width * scaler, self.stick.height * scaler)
end

function Stick:touched(touch)
    if touch.state == BEGAN then
        self.center = vec2(touch.x, touch.y)
        self.active = true
    end

    self.pos = vec2(touch.x, touch.y)
    self.direction = math.atan(self.pos.y - self.center.y, self.pos.x - self.center.x)

    self.dist = math.min(2, self.pos:dist(self.center)/32)

    if touch.state == ENDED then
        self.center = self.origin
        self.pos = self.center
        self.active = false
    end


end


